/******************************************************************************/
#include "stdafx.h"
#include <EsenthelEngine/EsenthelEngine.h>
/******************************************************************************/
Mesh       *chr      , // character mesh
            box      ; // box       mesh
Gfx        *main     , // main   explosion texture
           *single   ; // single explosion texture
ExplosionFx explosion; // explosion particle effect
/******************************************************************************/
void InitPre()
{
   App.name="Blood Effect";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak",NULL);

   Cam.dist=3;
   D.full(1).bumpMode(BUMP_PARALLAX).mtnMode(MTN_HIGH); // Explosion Effect makes use of Motion Blur
}
/******************************************************************************/
Bool Init()
{
   box.create(1).B(0).create(Box(2),VTX_TX0|VTX_NRM|VTX_TNG).reverse();
   box.setMaterial(Materials("mtrl/brick/0.mtrl")).setRender().setBox();

   chr=Meshs("obj/chr/human/0.mesh");

   main  =Gfxs("gfx/particle/explosion/0.gfx");
   single=Gfxs("gfx/particle/explosion/1.gfx");

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   // enable explosion effect
   if(Kb.bp(KB_SPACE)) // on space
   {
      explosion.create(main,single,0x00600000,32,Vec(0,0,0),1); // create explosion effect
      QuakeFx.addMedium();                                      // add medium earth quake
   }

   // update Explosion Effect
   explosion.update();

   // update Quake Effect
   QuakeFx.update();

   CamHandle(0.1f,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   return true;
}
/******************************************************************************/
Void Render()
{
   switch(Renderer())
   {
      case RM_SOLID  :
      case RM_SHD_MAP:
         box .draw(MatrixIdentity);
         chr->draw(Matrix(2).rotateY(PI));
      break;

      case RM_LIGHT:
         LightPoint(5,Vec(0,1,-1)).add();
      break;

      case RM_PRT_PAL:
         explosion.draw(); // draw Explosion Effect in Particle Palette mode
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,"Press Space to enable Explosion Effect");
}
/******************************************************************************/
